/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于处理关于大屏连接xml文件
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.9.11
 *      内容 : 所有代码
 *************************************************************************************************/
/* exported mc_sdk_sendcard */

/************************************************************************************************
 * 类型:
 *    构造函数
 * 功能:
 *    生成/解析大屏连接xml文件
 * 参数:
 *    NA
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.9.11
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_sdk_sendcard() {
    var m_obj_sendcard_xml_template = {
        "tagName": "screen",
        "attrs": {
            "version": "1.0",
            "screen_width": "0",
            "screen_height": "0",
            "screen_box_cnt": "0"
        },
        "children": [{
            "tagName": "box_data",
            "children": []
        }]
    };

    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    获取屏幕宽度
     * 参数:
     *    NA
     * 返回：
     *    @returns {Promise<String>} 屏幕宽度
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.14
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_sreen_msg_width = function () {
        return m_obj_sendcard_xml_template.attrs.screen_width;
    };
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    获取屏幕高度
     * 参数:
     *    NA
     * 返回：
     *    @returns {Promise<String>} 屏幕高度
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.14
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_sreen_msg_height = function () {
        return m_obj_sendcard_xml_template.attrs.screen_height;
    };
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    获取屏幕箱体数量
     * 参数:
     *    NA
     * 返回：
     *    @returns {Promise<String>} 屏幕箱体数量
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.14
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_sreen_msg_box_cnt = function () {
        return m_obj_sendcard_xml_template.attrs.screen_box_cnt;
    };
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    存入屏幕宽度(与屏幕发送卡数据无关,仅做记录使用)
     * 参数:
     *    @param {Promise<String>} str_screen_w 屏幕宽度
     * 返回：
     *    @returns {Promise<Boolean>} 储存结果
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.14
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_sreen_msg_width = function (str_screen_w) {
        if (!str_screen_w || "string" !== typeof str_screen_w) {
            return false;
        }
        m_obj_sendcard_xml_template.attrs.screen_width = str_screen_w;
        return true;
    };
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    存入屏幕高度(与屏幕发送卡数据无关,仅做记录使用)
     * 参数:
     *    @param {Promise<String>} str_screen_h 屏幕高度
     * 返回：
     *    @returns {Promise<Boolean>} 储存结果
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.14
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_sreen_msg_height = function (str_screen_h) {
        if (!str_screen_h || "string" !== typeof str_screen_h) {
            return false;
        }
        m_obj_sendcard_xml_template.attrs.screen_height = str_screen_h;
        return true;
    };
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    存入屏幕箱体数量(与屏幕发送卡数据无关,仅做记录使用)
     * 参数:
     *    @param {Promise<String>} str_screen_box_cnt 屏幕箱体数量
     * 返回：
     *    @returns {Promise<Boolean>} 储存结果
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.14
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_sreen_msg_box_cnt = function (str_screen_box_cnt) {
        if (!str_screen_box_cnt || "string" !== typeof str_screen_box_cnt) {
            return false;
        }
        m_obj_sendcard_xml_template.attrs.screen_box_cnt = str_screen_box_cnt;
        return true;
    };
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    获取接收卡数据
     * 参数:
     *    NA
     * 返回：
     *    @returns {Promise<Array>} 文件所有箱体数据
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.11
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_box_list = function () {
        var ary_data_list = m_obj_sendcard_xml_template.children;

        if (!Array.isArray(ary_data_list) || 0 >= ary_data_list.length) {
            return [];
        }
        var ui_box_list_idx = -1;

        for (var idx_list = 0; idx_list < ary_data_list.length; idx_list++) {
            var obj_data = ary_data_list[idx_list];
            var str_tagName = obj_data.tagName;

            if ("box_data" === str_tagName) {
                ui_box_list_idx = idx_list;
                break;
            }
        }
        if (0 > ui_box_list_idx) {
            return [];
        }
        var obj_box_data = ary_data_list[ui_box_list_idx];
        var ary_box_list = obj_box_data.children;
        var ary_return = [];

        for (var idx_box = 0; idx_box < ary_box_list.length; idx_box++) {
            var obj_box = ary_box_list[idx_box];

            if (
                !obj_box.attrs.id ||
                !obj_box.data
            ) {
                var ary_trans_list = obj_box.children;

                for (var idx_trans = 0; idx_trans < ary_trans_list.length; idx_trans++) {
                    var obj_trans = ary_trans_list[idx_trans];

                    if (
                        !obj_trans.attrs ||
                        !obj_trans.attrs.mirror ||
                        !obj_trans.attrs.rotation ||
                        !obj_trans.attrs.scale ||
                        !obj_trans.data
                    ) {
                        continue;
                    }
                    ary_return.push({
                        box_name: obj_box.attrs.id,
                        box_data: obj_trans.data,
                        mirror: obj_trans.attrs.mirror,
                        rotation: obj_trans.attrs.rotation,
                        scale: obj_trans.attrs.scale,
                        cur: obj_trans.attrs.cur || "0,0,0,0"
                    });
                }
            } else {
                ary_return.push({
                    box_name: obj_box.attrs.id,
                    box_data: obj_box.data,
                    mirror: "0",
                    rotation: "0,0,0",
                    scale: "0.0,0.0,1.0,1.0",
                    cur: "0,0,0,0"
                });
            }
        }


        return ary_return;
    };

    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    获取当前数据
     * 参数:
     *    NA
     * 返回：
     *    @returns {Promise<Array>} 接收卡数据
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.11
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_recvcard_data = function () {
        var ary_return = [];
        var ary_parse_list = m_obj_sendcard_xml_template.children;

        mc_parse_rec_data(ary_return, ary_parse_list);

        return ary_return;
    };

    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    解析数据数组存入储存数组中
     * 参数:
     *    @param {Promise<Array>} ary_set_obj 储存数组
     *    @param {Promise<Array>} ary_parse_list 解析数据数组
     * 返回：
     *   NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.11
     *      内容 : 所有代码
     ************************************************************************************************/
    function mc_parse_rec_data(ary_set_obj, ary_parse_list) {
        if (!Array.isArray(ary_parse_list) || 0 >= ary_parse_list.length) {
            return;
        }

        for (var idx_list = 0; idx_list < ary_parse_list.length; idx_list++) {
            var obj_pase_data = ary_parse_list[idx_list];
            var str_tagName = obj_pase_data.tagName;

            if ("box_data" === str_tagName) {
                continue;
            }
            var obj_attrs_val = obj_pase_data.attrs;
            var str_id = obj_attrs_val.id;
            var obj_parse = {
                NAME: "",
                X: obj_attrs_val.img_x,
                Y: obj_attrs_val.img_y,
                W: obj_attrs_val.img_w,
                H: obj_attrs_val.img_h,
                CHILD: []
            };

            switch (str_tagName) {
            case "vcm":
                obj_parse.NAME = "SENDCARD";
                break;
            case "vcm_outport":
                obj_parse.NAME = "SENDPORT";
                break;
            case "hub":
                obj_parse.NAME = "HUB";
                break;
            case "hub_port":
                obj_parse.NAME = "HUBPORT";
                break;
            case "vcs":
                obj_parse.CHIP_NAME = obj_attrs_val.ctrlchip;
                obj_parse.box_name = obj_attrs_val.box_name;
                obj_parse.ctrlchip = obj_attrs_val.ctrlchip;
                obj_parse.vcs_addr = obj_attrs_val.id;
                obj_parse.vcs_orign_width = obj_attrs_val.orign_w;
                obj_parse.vcs_orign_height = obj_attrs_val.orign_h;
                obj_parse.offset_x = obj_attrs_val.orign_x;
                obj_parse.offset_y = obj_attrs_val.orign_y;
                obj_parse.mirror = obj_attrs_val.mirror;
                obj_parse.rotation = obj_attrs_val.rotation;
                obj_parse.scale = obj_attrs_val.scale;
                obj_parse.cut = obj_attrs_val.cut;
                break;
            case "invalid":
                obj_parse.NAME = "?";
                break;
            default:
                continue;
            }
            var ary_set_list = obj_pase_data.children;
            var ary_set_obj_loc = obj_parse.CHILD;

            mc_parse_rec_data(ary_set_obj_loc, ary_set_list);

            ary_set_obj[str_id] = obj_parse;
        }
        return;
    }

    /************************************************************************************************
     * 类型:
     *   内部函数
     * 功能:
     *   存入图像信息列表,根据列表构造完整的图像信息
     * 参数:
     *    @param {Promise<Array>} ary_img_list 图像信息列表
     * 返回：
     *    @returns {Boolean} true 正常 || false 错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.12
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_img_data = function (ary_img_list) {
        if (!Array.isArray(ary_img_list) || 0 >= ary_img_list.length) {
            return false;
        }
        var obj_send_list = m_obj_sendcard_xml_template;

        if (mc_set_send_list(obj_send_list, ary_img_list)) {
            return true;
        }
        return false;
    };

    /************************************************************************************************
     * 类型:
     *   内部函数
     * 功能:
     *   存入发送卡端口图像信息
     * 参数:
     *    @param {Promise<Object>} obj_data 需要存入的发送卡数据 对象
     *    @param {Promise<Array>} ary_chip_list 图像信息列表
     * 返回：
     *    @returns {Boolean} true 正常 || false 错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.12
     *      内容 : 所有代码
     ************************************************************************************************/
    function mc_set_send_list(obj_data, ary_chip_list) {
        if (
            !Array.isArray(ary_chip_list) ||
            0 >= ary_chip_list.length
        ) {
            return true;
        }
        var ary_set_list = obj_data.children;

        for (var idx_port = 0; idx_port < ary_chip_list.length; idx_port++) {
            var obj_chip_data = ary_chip_list[idx_port];

            if (
                "[object Object]" !== Object.prototype.toString.call(obj_chip_data) ||
                0 >= Object.keys(obj_chip_data).length
            ) {
                continue;
            }
            if (
                "undefined" === typeof obj_chip_data.X ||
                "undefined" === typeof obj_chip_data.Y ||
                "undefined" === typeof obj_chip_data.W ||
                "undefined" === typeof obj_chip_data.H
            ) {
                obj_chip_data.X = "-1";
                obj_chip_data.Y = "-1";
                obj_chip_data.W = "-1";
                obj_chip_data.H = "-1";
            }
            var str_chip_name = obj_chip_data.NAME;

            if (obj_chip_data.ctrlchip) {
                str_chip_name = "RECEIVE";
            }
            var obj_set_data = {
                "tagName": "",
                "attrs": {
                    "id": idx_port.toString(),
                    "img_x": obj_chip_data.X,
                    "img_y": obj_chip_data.Y,
                    "img_w": obj_chip_data.W,
                    "img_h": obj_chip_data.H
                },
                "children": []
            };

            var ary_set_chip_list = obj_chip_data.CHILD;

            switch (str_chip_name) {
            case "SENDCARD":
                obj_set_data.tagName = "vcm";
                break;
            case "SENDPORT":
                obj_set_data.tagName = "vcm_outport";
                break;
            case "HUB":
                obj_set_data.tagName = "hub";
                break;
            case "HUBPORT":
                obj_set_data.tagName = "hub_port";
                break;
            case "RECEIVE":
                obj_set_data.tagName = "vcs";
                obj_set_data.attrs.box_name = obj_chip_data.box_name;
                obj_set_data.attrs.ctrlchip = obj_chip_data.ctrlchip;
                obj_set_data.attrs.orign_w = obj_chip_data.vcs_orign_width;
                obj_set_data.attrs.orign_h = obj_chip_data.vcs_orign_height;
                obj_set_data.attrs.orign_x = obj_chip_data.offset_x;
                obj_set_data.attrs.orign_y = obj_chip_data.offset_y;
                obj_set_data.attrs.mirror = obj_chip_data.mirror;
                obj_set_data.attrs.rotation = obj_chip_data.rotation;
                obj_set_data.attrs.scale = obj_chip_data.scale;
                obj_set_data.attrs.cut = obj_chip_data.cut;
                break;
            case "?":
                obj_set_data.tagName = "invalid";
                break;
            default:
                return false;
            }
            if (
                Array.isArray(ary_set_chip_list) &&
                0 < ary_set_chip_list.length
            ) {
                mc_set_send_list(obj_set_data, ary_set_chip_list);
            }

            ary_set_list.push(obj_set_data);
        }
        return true;
    }

    /************************************************************************************************
     * 类型:
     *   内部函数
     * 功能:
     *   存入箱体所有箱体数据(重复箱体不添加)
     * 参数:
     *    @param {Promise<Object>} obj_box_list 箱体数据对象
     * 返回：
     *    NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.12
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_box_list = function (obj_box_list) {
        for (var str_box_name in obj_box_list) {
            if (Object.prototype.hasOwnProperty.call(obj_box_list, str_box_name)) {
                mc_set_box_data(obj_box_list[str_box_name], obj_box_list[str_box_name].name);
            }
        }
        return;
    };
    /************************************************************************************************
     * 类型:
     *   内部函数
     * 功能:
     *   存入箱体数据(重复箱体不添加)
     * 参数:
     *    @param {Promise<String>} obj_box 箱体数据
     *    @param {Promise<String>} str_box_name 箱体名称
     * 返回：
     *    NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.12
     *      内容 : 所有代码
     ************************************************************************************************/
    function mc_set_box_data(obj_box, str_box_name) {
        var obj_box_data_list = m_obj_sendcard_xml_template.children[0];
        var ary_box_list = obj_box_data_list.children;

        for (var idx = 0; idx < ary_box_list.length; idx++) {
            var obj_box_data = ary_box_list[idx];
            var str_box_name_loc = obj_box_data.attrs.id;

            if (str_box_name_loc === str_box_name) {
                var ary_box_childre = obj_box_data.children;

                for (var idx_trans = 0; idx_trans < ary_box_childre.length; idx_trans++) {
                    var obj_trans_tag = ary_box_childre[idx_trans];

                    if (
                        obj_box.mirror === obj_trans_tag.attrs.mirror &&
                        obj_box.rotation === obj_trans_tag.attrs.rotation &&
                        obj_box.scale === obj_trans_tag.attrs.scale
                    ) {
                        return;
                    }
                }
                ary_box_list[idx].children.push({
                    "tagName": "box_trans",
                    "attrs": {
                        "mirror": obj_box.mirror,
                        "rotation": obj_box.rotation,
                        "scale": obj_box.scale
                    },
                    "data": obj_box.data
                });
                return;
            }
        }
        ary_box_list.push({
            "tagName": "box",
            "attrs": {
                "id": str_box_name
            },
            "children": [{
                "tagName": "box_trans",
                "attrs": {
                    "mirror": obj_box.mirror,
                    "rotation": obj_box.rotation,
                    "scale": obj_box.scale
                },
                "data": obj_box.data

            }]
        });
    }

    /************************************************************************************************
     * 类型:
     *   内部函数
     * 功能:
     *   存入解析xml字串
     * 参数:
     *    @param {Promise<String>} str_send_xml xml字串
     * 返回：
     *    @returns {Boolean} true 解析成功 || false 解析失败
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.11
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_send_xml = function (str_send_xml) {
        if ("string" !== typeof str_send_xml || 0 >= str_send_xml.length) {
            return false;
        }
        var obj_xml_template = new mc_xml_template();

        obj_xml_template.set_xml_template(m_obj_sendcard_xml_template);
        if (obj_xml_template.set_xml_text(str_send_xml)) {
            m_obj_sendcard_xml_template = obj_xml_template.query_object("screen");
            return true;
        }
        return false;
    };

    /************************************************************************************************
     * 类型:
     *   内部函数
     * 功能:
     *   获取发送卡xml字串
     * 参数:
     *    NA
     * 返回：
     *    @returns {String} 发送卡xml文件字串
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.11
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_sencdcard_xml_text = function () {
        var obj_xml_template = new mc_xml_template();

        obj_xml_template.set_xml_template(m_obj_sendcard_xml_template);
        return obj_xml_template.get_xml_text();
    };
}


/* exported mc_xml_template */
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    解析模板对象生成对应的xml字符串,解析xml字符串生成对应的模板对象
 * 参数:
 *    NA
 * 返回：
 *   NA
 * 例子：
 *    NA
 * 备注：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.9.3
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_xml_template() {
    var m_obj_xml_template = {};

    function get_attributes(element) {
        if (element.attributes.length) {
            var res = {};

            for (var i = 0; i < element.attributes.length; i++) {
                res[element.attributes[i].name] = element.attributes[i].value;
            }
            return res;
        }
        return "";
    }

    function parse_node(element, dst) {
        dst.tagName = element.tagName;
        var attrs = get_attributes(element);

        if (attrs) {
            dst.attrs = attrs;
        }
        var elementNodes = Array.prototype.filter.call(element.childNodes, function (node) {
            return 1 === node.nodeType;
        });
        var textNodes = Array.prototype.filter.call(element.childNodes, function (node) {
            return 3 === node.nodeType;
        });
        var data = (function () {
            var s = "";

            for (var i = 0; i < textNodes.length; i++) {
                s += textNodes[i].textContent;
            }
            return s.trim();
        }());

        if (data.trim().length) {
            dst.data = data;
        }
        if (elementNodes.length) {
            dst.children = [];
        }
        for (var i = 0; i < elementNodes.length; i++) {
            dst.children[i] = {};
            parse_node(elementNodes[i], dst.children[i]);
        }
    }

    function parse_element(box) {
        var res = {};

        parse_node(box, res);
        if (!Object.prototype.hasOwnProperty.call(res, "tagName")) {
            return m_obj_xml_template;
        }
        for (var i = 0; i < m_obj_xml_template.children.length; i++) {
            if (i >= res.children.length) {
                res.children.push(m_obj_xml_template.children[i]);
            } else if (res.children[i].tagName !== m_obj_xml_template.children[i].tagName) {
                res.children.splice(i, 0, m_obj_xml_template.children[i]);
            }
        }
        return res;
    }

    function start_tag(obj) {
        return "<" + obj.tagName;
    }

    function set_atrribute(obj) {
        var res = "";
        var keys = obj.attrs ? Object.keys(obj.attrs) : [];

        for (var i = 0; i < keys.length; i++) {
            res += " " + keys[i] + "=" + "\"" + obj.attrs[keys[i]] + "\"";
        }
        if (obj.data || obj.children) {
            res += ">";
        }
        return res;
    }

    function set_data_inner_use(obj) {
        return obj.data ? obj.data : "";
    }

    function close_tag(obj) {
        if (obj.data || obj.children) {
            var str_rertrn = "</" + obj.tagName + ">";

            if (obj.children) {
                str_rertrn = "\n" + str_rertrn;
            }
            return str_rertrn;
        }
        return "/>";
    }

    function pack(obj) {
        var s = "\n";

        s += start_tag(obj);
        s += set_atrribute(obj);
        s += set_data_inner_use(obj);
        for (var i = 0; obj.children && i < obj.children.length; i++) {
            s += pack(obj.children[i]);
        }
        s += close_tag(obj);
        return s;
    }

    function get_xml_text(box) {
        return "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + pack(box);
    }

    function query(obj, tagName) {
        var attrs = attrbutes(tagName);
        var tag = tagName.split("[")[0];
        var i = 0;

        if (obj.tagName === tag) {
            var match = true;

            for (i = 0; i < attrs.length; i++) {
                var key = attrs[i][0];
                var value = attrs[i][1];

                if (value) {
                    if (obj.attrs && obj.attrs[key] !== value) {
                        match = false;
                    }
                } else {
                    if (obj.attrs && !Object.prototype.hasOwnProperty.call(obj.attrs, key)) {
                        match = false;
                    }
                }
            }
            if (match) {
                return obj;
            }
        }
        for (i = 0; obj.children && i < obj.children.length; i++) {
            var obj_tag = query(obj.children[i], tagName);

            if (obj_tag) {
                return obj_tag;
            }
        }
        return {};
    }

    function attrbutes(str) {
        str = str.replace(/\s+/g, "");
        var m = str.match(/\w+\[(.+)\]/);

        if (m) {
            var attrs = m[1].split("and");

            return attrs.map(function (e) {
                var a = e.split("=");

                a[0] = a[0].slice(1);
                return a;
            });
        }
        return [];
    }

    function query_object(root, select) {
        var tags = select.split("/");
        var obj_tmp = root;

        for (var i = 0; i < tags.length; i++) {
            obj_tmp = query(obj_tmp, tags[i]);
            if (!obj_tmp) {
                return {};
            }
        }
        return obj_tmp;
    }
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    存入解析对象
     * 参数:
     *    @param {promises<JSON.Object>} obj_xml_template xml模板json对象
     * 返回：
     *   @returns  {promises<Boolean>} true 表示设置成功, false 设置失败
     * 例子：
     *    NA
     * 备注：
     *    NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.3
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_xml_template = function (obj_xml_template) {
        if (
            "object" !== typeof obj_xml_template ||
            !obj_xml_template.tagName
        ) {
            return false;
        }
        m_obj_xml_template = obj_xml_template;
        return true;
    };
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    获取指定的箱体标签
     * 参数:
     *    @param {promises<string>} select 选择符 / 分隔标签 []里指定属性, @attribute=value格式，and分隔多个属性，格式为a/b[@attr1=value1 and attr2=value2 and attr3]/
     * 返回：
     *    @returns {promises<boolean>} 操作结果
     * 例子：
     *    'module_data/str[@pin_id=C2]/item[@x=1 and @y=0]' 返回 一个item标签的Object对象，此对象位于module_data 下str标签之下，
     *    其中str的pin_id=2, item的x=1,y=0
     * 备注：
     *    NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 曹冰星
     *      时间 : 2019.10.31
     *      内容 : 所有代码
     ************************************************************************************************/
    this.query_object = function (select) {
        return query_object(m_obj_xml_template, select);
    };
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    存入解析字串
     * 参数:
     *    @param {promises<string>} str_xml_text xml格式字符串数据
     * 返回：
     *   @returns  {promises<string>} true 表示设置成功, false 设置失败,使用默认值
     * 例子：
     *    NA
     * 备注：
     *    NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 曹冰星
     *      时间 : 2019.10.31
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_xml_text = function (str_xml_text) {
        var parser = new DOMParser();
        var doc = parser.parseFromString(str_xml_text, "text/xml");
        var box = doc.getElementsByTagName(m_obj_xml_template.tagName)[0];

        if (!box) {
            return false;
        }
        var old_table = m_obj_xml_template;

        m_obj_xml_template = parse_element(box);
        if (old_table === m_obj_xml_template) {
            return false;
        }
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    对象转换为xml格式数据
     * 参数:
     *    NA
     * 返回：
     *    @returns {promises<boolean>} xml格式数据
     * 例子：
     *    NA
     * 备注：
     *    NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 曹冰星
     *      时间 : 2019.10.31
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_xml_text = function () {
        return get_xml_text(m_obj_xml_template);
    };
}
